package ru.yandex.direct.core.entity.banner.type.aggregatordomain;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithAggregatorDomain;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.model.BannerWithAggregatorDomain.DOMAIN;
import static ru.yandex.direct.core.entity.banner.model.BannerWithAggregatorDomain.HREF;
import static ru.yandex.direct.utils.FunctionalUtils.filterList;

@Component
@ParametersAreNonnullByDefault
public class BannerWithAggregatorDomainUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithAggregatorDomain> {

    private final AggregatorDomainProcessor aggregatorDomainProcessor;

    @Autowired
    public BannerWithAggregatorDomainUpdateOperationTypeSupport(
            AggregatorDomainProcessor aggregatorDomainProcessor) {
        this.aggregatorDomainProcessor = aggregatorDomainProcessor;
    }

    @Override
    public void updateRelatedEntitiesInTransaction(DSLContext dslContext, BannersUpdateOperationContainer updateContainer,
                                                   List<AppliedChanges<BannerWithAggregatorDomain>> appliedChanges) {
        aggregatorDomainProcessor.updateAggregatorDomains(dslContext,
                filterList(appliedChanges, ac -> ac.changed(HREF) || ac.changed(DOMAIN)));
    }

    @Override
    public Class<BannerWithAggregatorDomain> getTypeClass() {
        return BannerWithAggregatorDomain.class;
    }
}
