package ru.yandex.direct.core.entity.banner.type.banner;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.model.BannerWithIsMobile;
import ru.yandex.direct.core.entity.banner.model.BannerWithSitelinks;
import ru.yandex.direct.core.entity.banner.model.BannerWithVcard;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractBannerRepositoryTypeSupport;
import ru.yandex.direct.dbschema.ppc.enums.BannersPhoneflag;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatussitelinksmoderate;
import ru.yandex.direct.dbschema.ppc.enums.BannersType;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;

import static java.util.Collections.singletonList;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;

@Component
@ParametersAreNonnullByDefault
public class BannerRepositoryTypeSupport
        extends AbstractBannerRepositoryTypeSupport<Banner> {

    @Autowired
    public BannerRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public Collection<Field<?>> getFields() {
        return singletonList(BANNERS.BID);
    }

    @Override
    public <M extends Banner> void fillFromRecord(M model, Record record) {
        model.setId(record.get(BANNERS.BID));
    }

    @Override
    public Class<Banner> getTypeClass() {
        return Banner.class;
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator, Banner model) {
        //при добавлении двух баннеров разных типов, например текстовый и contentPromotion
        //возникает ошибка при записи в таблицу banners вида "поле type cannot be null"
        //т.к. contentPromotion баннер не наследует интерфейс BannerWithIsMobile, то при построении insert-а
        //записывается null в not null поле.
        //Чтобы избежать таких ошибок добавляем дефолтные значения всем баннерам, у которых нет таких полей
        var insertHelper = insertHelperAggregator.getOrCreate(BANNERS);
        insertHelper.set(BANNERS.BID, model.getId());
        if (!(model instanceof BannerWithIsMobile)) {
            insertHelper.set(BANNERS.TYPE, BannersType.desktop);
        }
        if (!(model instanceof BannerWithSitelinks)) {
            insertHelper.set(BANNERS.STATUS_SITELINKS_MODERATE, BannersStatussitelinksmoderate.New);
        }
        if (!(model instanceof BannerWithVcard)) {
            insertHelper.set(BANNERS.PHONEFLAG, BannersPhoneflag.New);
        }
    }
}
