package ru.yandex.direct.core.entity.banner.type.banner;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.ImmutableBanner;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelChangesValidationBuilder;

import static ru.yandex.direct.core.entity.banner.service.validation.BannerConstraints.bannerIsDraftOrNotChanged;

@Component
@ParametersAreNonnullByDefault
public class ImmutableBannerUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<ImmutableBanner> {

    @Override
    public ValidationResult<List<ModelChanges<ImmutableBanner>>, Defect> validateBeforeApply(
            BannersUpdateOperationContainer container,
            ValidationResult<List<ModelChanges<ImmutableBanner>>, Defect> vr,
            Map<Long, ImmutableBanner> unmodifiedModels) {

        ListValidationBuilder<ModelChanges<ImmutableBanner>, Defect> lvb = new ListValidationBuilder<>(vr);

        lvb.checkEachBy(mc -> ModelChangesValidationBuilder.of(mc)
                .check(bannerIsDraftOrNotChanged(unmodifiedModels))
                .getResult()
        );

        return lvb.getResult();
    }

    @Override
    public Class<ImmutableBanner> getTypeClass() {
        return ImmutableBanner.class;
    }
}
