package ru.yandex.direct.core.entity.banner.type.bannerimage

import ru.yandex.direct.core.entity.banner.model.BannerImageOpts

fun optsFromDb(opts: String?): Set<BannerImageOpts>? {
    if (opts == null) {
        return null
    }
    return if (opts.isEmpty()) {
        emptySet()
    } else opts.split(",")
        .map { BannerImageOpts.fromTypedValue(it) }
        .toSet()
}

fun optsToDb(bannerImageOpts: Set<BannerImageOpts>?): String? {
    if (bannerImageOpts == null) {
        return null
    }
    return if (bannerImageOpts.isEmpty()) {
        ""
    } else bannerImageOpts
        .joinToString(separator = ",") { it.typedValue }
}
