package ru.yandex.direct.core.entity.banner.type.bannerimage;

import java.util.Map;

import ru.yandex.direct.core.entity.banner.model.BannerWithBannerImage;
import ru.yandex.direct.core.entity.banner.model.ImageType;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelChangesValidationBuilder;

import static ru.yandex.direct.core.entity.banner.type.bannerimage.BannerWithBannerImageConstraints.bannerImageTypeIsNotChangedToSmall;

public class BannerImageModificationValidator implements Validator<ModelChanges<BannerWithBannerImage>, Defect> {

    private final Map<String, ImageType> typedHashes;
    private final Map<Long, BannerWithBannerImage> unmodifiedModels;

    public BannerImageModificationValidator(Map<String, ImageType> typedHashes,
                                               Map<Long, BannerWithBannerImage> unmodifiedModels) {
        this.typedHashes = typedHashes;
        this.unmodifiedModels = unmodifiedModels;
    }

    @Override
    public ValidationResult<ModelChanges<BannerWithBannerImage>, Defect> apply(ModelChanges<BannerWithBannerImage> changes) {
        ModelChangesValidationBuilder<BannerWithBannerImage> vb = ModelChangesValidationBuilder.of(changes);

        vb.check(bannerImageTypeIsNotChangedToSmall(unmodifiedModels, typedHashes),
                When.valueIs(mc -> changes.isPropChanged(BannerWithBannerImage.IMAGE_HASH)));

        return vb.getResult();
    }
}
