package ru.yandex.direct.core.entity.banner.type.bannerimage;

import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerImageOpts;
import ru.yandex.direct.core.entity.banner.model.BannerWithBannerImage;
import ru.yandex.direct.core.entity.banner.model.StatusBannerImageModerate;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;
import ru.yandex.direct.core.entity.feature.service.FeatureService;

import static ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.isEffectiveSaveDraft;
import static ru.yandex.direct.feature.FeatureName.SINGLE_IMAGE_AD_TO_BS;

@Component
public class BannerWithBannerImageAddOperationTypeSupport
        extends AbstractBannerAddOperationTypeSupport<BannerWithBannerImage> {

    private final FeatureService featureService;

    @Autowired
    public BannerWithBannerImageAddOperationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<BannerWithBannerImage> getTypeClass() {
        return BannerWithBannerImage.class;
    }

    @Override
    public void beforeExecution(BannersAddOperationContainer addContainer, List<BannerWithBannerImage> models) {
        boolean singleAdToBSEnabled = featureService
                .isEnabledForClientId(addContainer.getClientId(), SINGLE_IMAGE_AD_TO_BS);
        models.forEach(banner -> fillSystemFields(addContainer, banner, singleAdToBSEnabled));
    }

    private void fillSystemFields(
            BannersAddOperationContainer addContainer,
            BannerWithBannerImage banner,
            boolean singleAdToBSEnabled) {
        var effectiveSaveDraft = isEffectiveSaveDraft(addContainer, banner);

        if (banner.getImageHash() != null) {
            banner.withImageId(null)
                    .withImageStatusModerate(
                            effectiveSaveDraft ? StatusBannerImageModerate.NEW : StatusBannerImageModerate.READY)
                    .withImageStatusShow(true)
                    .withImageBsBannerId(0L)
                    .withImageDateAdded(LocalDateTime.now());

            // Ставим флажок для отправки в БК в одном родительском баннере (вместо двух, картиночном и безкартиночном)
            if (singleAdToBSEnabled) {
                Set<BannerImageOpts> opts = banner.getOpts() != null
                        ? new HashSet<>(banner.getOpts())
                        : new HashSet<>();
                opts.add(BannerImageOpts.SINGLE_AD_TO_BS);
                banner.withOpts(opts);
            }
        }
    }
}
