package ru.yandex.direct.core.entity.banner.type.bannerimage;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithBannerImage;
import ru.yandex.direct.core.entity.banner.model.ImageType;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithBannerImageAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithBannerImage> {

    private final BannerWithBannerImageValidatorProvider validatorProvider;
    private final BannerWithBannerImageValidationHelper validationHelper;

    @Autowired
    public BannerWithBannerImageAddValidationTypeSupport(
            BannerWithBannerImageValidatorProvider validatorProvider,
            BannerWithBannerImageValidationHelper validationHelper) {
        this.validatorProvider = validatorProvider;
        this.validationHelper = validationHelper;
    }

    @Override
    public Class<BannerWithBannerImage> getTypeClass() {
        return BannerWithBannerImage.class;
    }


    @Override
    public ValidationResult<List<BannerWithBannerImage>, Defect> validate(
            BannersAddOperationContainer container,
            ValidationResult<List<BannerWithBannerImage>, Defect> vr) {

        Map<String, ImageType> typedHashes =
                validationHelper.getExistingTypedHashesForBanners(container, vr.getValue());

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerImageValidator(typedHashes, container.isCopy()))
                .getResult();
    }
}
