package ru.yandex.direct.core.entity.banner.type.bannerimage;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithBannerImage;
import ru.yandex.direct.core.entity.banner.model.ImageType;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithBannerImageUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithBannerImage> {

    private final BannerWithBannerImageValidatorProvider validatorProvider;
    private final BannerWithBannerImageValidationHelper validationHelper;

    @Autowired
    public BannerWithBannerImageUpdateValidationTypeSupport(
            BannerWithBannerImageValidatorProvider validatorProvider,
            BannerWithBannerImageValidationHelper validationHelper) {
        this.validatorProvider = validatorProvider;
        this.validationHelper = validationHelper;
    }

    @Override
    public Class<BannerWithBannerImage> getTypeClass() {
        return BannerWithBannerImage.class;
    }

    @Override
    public ValidationResult<List<ModelChanges<BannerWithBannerImage>>, Defect> validateBeforeApply(
            BannersUpdateOperationContainer container,
            ValidationResult<List<ModelChanges<BannerWithBannerImage>>, Defect> vr,
            Map<Long, BannerWithBannerImage> unmodifiedModels) {

        List<String> imageHashes = unmodifiedModels.values().stream()
                .map(BannerWithBannerImage::getImageHash)
                .filter(Objects::nonNull)
                .collect(Collectors.toList());

        vr.getValue().forEach(mc -> {
            String newImageHash = mc.getPropIfChanged(BannerWithBannerImage.IMAGE_HASH);
            if (newImageHash != null) {
                imageHashes.add(newImageHash);
            }
        });

        Map<String, ImageType> typedHashes = validationHelper.getExistingTypedHashes(container, imageHashes);

        return new ListValidationBuilder<>(vr)
                .checkEachBy(
                        validatorProvider.bannerImageModificationValidator(container, typedHashes, unmodifiedModels))
                .getResult();
    }

    @Override
    public ValidationResult<List<BannerWithBannerImage>, Defect> validate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<BannerWithBannerImage>, Defect> vr) {

        Map<String, ImageType> typedHashes =
                validationHelper.getExistingTypedHashesForBanners(container, vr.getValue());

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerImageValidator(typedHashes, true))
                .getResult();
    }

}
