package ru.yandex.direct.core.entity.banner.type.bannerimage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.BannerWithBannerImage;
import ru.yandex.direct.core.entity.banner.model.StatusBannerImageModerate;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.model.BannerWithBannerImage.IMAGE_HASH;
import static ru.yandex.direct.core.entity.banner.model.BannerWithBannerImage.IMAGE_STATUS_MODERATE;

@ParametersAreNonnullByDefault
public class BannerWithBannerImageUtils {

    private BannerWithBannerImageUtils() {
    }

    public static boolean isBannerImageChanged(@Nonnull AppliedChanges<? extends BannerWithBannerImage> ac) {

        String oldImageHash = ac.getOldValue(IMAGE_HASH);
        String newImageHash = ac.getNewValue(IMAGE_HASH);

        StatusBannerImageModerate oldBannerImageStatusModerate = ac.getOldValue(IMAGE_STATUS_MODERATE);
        StatusBannerImageModerate newBannerImageStatusModerate = ac.getNewValue(IMAGE_STATUS_MODERATE);

        return isBannerImageChanged(
                oldImageHash,
                newImageHash,
                oldBannerImageStatusModerate,
                newBannerImageStatusModerate);
    }

    public static boolean isBannerImageChanged(@Nullable String oldImageHash,
                                               @Nullable String newImageHash,
                                               @Nullable StatusBannerImageModerate oldImageStatusModerate,
                                               @Nullable StatusBannerImageModerate newImageStatusModerate) {

        boolean imageChanged;
        if (oldImageHash == null && newImageHash == null) {
            imageChanged = false;
        } else if (oldImageHash != null && newImageHash != null) {
            imageChanged = !newImageHash.equals(oldImageHash);
            imageChanged = imageChanged ||
                    (newImageStatusModerate != null
                            && newImageStatusModerate != oldImageStatusModerate);
        } else {
            imageChanged = true;
        }
        return imageChanged;
    }

}
