package ru.yandex.direct.core.entity.banner.type.bannerimage;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithBannerImage;
import ru.yandex.direct.core.entity.banner.model.ImageType;
import ru.yandex.direct.core.entity.image.repository.BannerImageFormatRepository;

import static ru.yandex.direct.utils.FunctionalUtils.filterAndMapList;

@Component
public class BannerWithBannerImageValidationHelper {

    private final BannerImageFormatRepository bannerImageFormatRepository;

    public BannerWithBannerImageValidationHelper(BannerImageFormatRepository bannerImageFormatRepository) {
        this.bannerImageFormatRepository = bannerImageFormatRepository;
    }

    /**
     * Получить сохраненные в БД хеши изображений и их типы
     */
    public Map<String, ImageType> getExistingTypedHashesForBanners(BannersOperationContainer container,
                                                                   List<BannerWithBannerImage> banners) {

        List<String> imageHashes =
                filterAndMapList(banners, x -> x.getImageHash() != null, BannerWithBannerImage::getImageHash);

        return getExistingTypedHashes(container, imageHashes);
    }

    public Map<String, ImageType> getExistingTypedHashes(BannersOperationContainer container,
                                                         List<String> imageHashes) {

        return bannerImageFormatRepository.getExistingImageHashesWithType(
                container.getShard(),
                container.getClientId(),
                imageHashes);
    }
}
