package ru.yandex.direct.core.entity.banner.type.bannerimage;

import java.util.Map;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithBannerImage;
import ru.yandex.direct.core.entity.banner.model.DynamicBanner;
import ru.yandex.direct.core.entity.banner.model.ImageType;
import ru.yandex.direct.core.entity.banner.model.MobileAppBanner;
import ru.yandex.direct.core.entity.banner.model.TextBanner;
import ru.yandex.direct.core.entity.banner.service.validation.BannerImageHashValidator;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelChangesValidationBuilder;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

@Component
public class BannerWithBannerImageValidatorProvider {

    public Validator<ModelChanges<BannerWithBannerImage>, Defect> bannerImageModificationValidator(
            BannersUpdateOperationContainer container,
            Map<String, ImageType> typedHashes,
            Map<Long, BannerWithBannerImage> unmodifiedModels) {

        return mc -> {

            ModelChangesValidationBuilder<BannerWithBannerImage> vb = ModelChangesValidationBuilder.of(mc);

            Class<?> runtimeClass = container.getRuntimeClass(mc.getId());
            if (TextBanner.class.isAssignableFrom(runtimeClass)
                    || DynamicBanner.class.isAssignableFrom(runtimeClass)) {
                vb.checkBy(new BannerImageModificationValidator(typedHashes, unmodifiedModels));
            }

            return vb.getResult();
        };
    }

    public Validator<BannerWithBannerImage, Defect> bannerImageValidator(
            Map<String, ImageType> typedHashes, boolean allowSmallImages) {
        return banner -> {

            boolean regularImageAllowed = false;
            boolean smallImageAllowed = false;
            if (banner instanceof TextBanner || banner instanceof DynamicBanner || banner instanceof MobileAppBanner) {
                regularImageAllowed = true;
                smallImageAllowed = allowSmallImages;
            }

            ModelItemValidationBuilder<BannerWithBannerImage> vb = ModelItemValidationBuilder.of(banner);

            vb.item(BannerWithBannerImage.IMAGE_HASH)
                    .checkBy(new BannerImageHashValidator(typedHashes,
                            regularImageAllowed,
                            smallImageAllowed));

            return vb.getResult();
        };
    }
}
