package ru.yandex.direct.core.entity.banner.type.bannerimage.moderation;

import java.util.List;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithBannerImageModeration;
import ru.yandex.direct.core.entity.banner.service.moderation.BannerWithChildrenModerationProvider;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
public class BannerWithBannerImageModerationUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithBannerImageModeration> {

    private final BannerWithChildrenModerationProvider<BannerWithBannerImageModeration> provider;

    @Autowired
    public BannerWithBannerImageModerationUpdateOperationTypeSupport(
            List<BannerWithBannerImageModerationProcessor> processors) {

        this.provider = new BannerWithChildrenModerationProvider<>(
                DefaultBannerWithBannerImageModerationProcessor.class,
                processors);
    }

    @Override
    public Class<BannerWithBannerImageModeration> getTypeClass() {
        return BannerWithBannerImageModeration.class;
    }

    @Override
    public void beforeExecutionInTransaction(
            DSLContext dsl,
            BannerAdditionalActionsContainer additionalActionsContainer,
            BannersUpdateOperationContainer updateContainer,
            List<AppliedChanges<BannerWithBannerImageModeration>> appliedChanges) {
        provider.process(dsl, additionalActionsContainer, updateContainer, appliedChanges);
    }
}
