package ru.yandex.direct.core.entity.banner.type.bigkingimage;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithBigKingImage;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithBigKingImageAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithBigKingImage> {
    private final BannerWithBigKingImageValidatorProvider validatorProvider;

    @Autowired
    public BannerWithBigKingImageAddValidationTypeSupport(BannerWithBigKingImageValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithBigKingImage> getTypeClass() {
        return BannerWithBigKingImage.class;
    }

    @Override
    public ValidationResult<List<BannerWithBigKingImage>, Defect> validate(
            BannersAddOperationContainer container, ValidationResult<List<BannerWithBigKingImage>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithBigKingImageValidator(
                        container, container.getClientEnabledFeatures()))
                .getResult();
    }
}
