package ru.yandex.direct.core.entity.banner.type.bigkingimage;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.util.mysql.MySQLDSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithBigKingImage;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractFlatRelatedEntityUpsertRepositoryTypeSupport;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerImageAssetRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_IMAGE_ASSET;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@Component
@ParametersAreNonnullByDefault
public class BannerWithBigKingImageRepositoryTypeSupport extends AbstractFlatRelatedEntityUpsertRepositoryTypeSupport
        <BannerWithBigKingImage, BannerImageAssetRecord> {

    @Autowired
    public BannerWithBigKingImageRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider, BANNER_IMAGE_ASSET.BID, createMapper());
    }

    @Override
    public void upsertEntity(DSLContext context, Collection<BannerWithBigKingImage> banners) {

        InsertHelper<BannerImageAssetRecord> insertHelper = new InsertHelper<>(context, BANNER_IMAGE_ASSET)
                .addAll(getJooqMapper(), banners);

        insertHelper.onDuplicateKeyUpdate()
                .set(BANNER_IMAGE_ASSET.IMAGE_HASH, MySQLDSL.values(BANNER_IMAGE_ASSET.IMAGE_HASH));

        insertHelper.executeIfRecordsAdded();
    }

    @Override
        protected boolean isAddEntity(BannerWithBigKingImage model) {
            return model.getBigKingImageHash() != null;
        }

    @Override
    protected boolean isUpsertEntity(AppliedChanges<BannerWithBigKingImage> appliedChange) {
        return !isDeleteEntity(appliedChange) &&
                (appliedChange.assigned(BannerWithBigKingImage.BIG_KING_IMAGE_HASH) ||
                 appliedChange.replaced(BannerWithBigKingImage.BIG_KING_IMAGE_HASH));
    }

    @Override
    protected boolean isDeleteEntity(AppliedChanges<BannerWithBigKingImage> appliedChange) {
        return appliedChange.deleted(BannerWithBigKingImage.BIG_KING_IMAGE_HASH);
    }

    @Override
    public Class<BannerWithBigKingImage> getTypeClass() {
        return BannerWithBigKingImage.class;
    }

    private static JooqMapper<BannerWithBigKingImage> createMapper() {
        return JooqMapperBuilder.<BannerWithBigKingImage>builder()
                .map(property(BannerWithBigKingImage.BIG_KING_IMAGE_HASH, BANNER_IMAGE_ASSET.IMAGE_HASH))
                .writeField(BANNER_IMAGE_ASSET.BID, fromProperty(BannerWithBigKingImage.ID))
                .build();
    }
}
