package ru.yandex.direct.core.entity.banner.type.bigkingimage;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithBigKingImage;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class BannerWithBigKingImageUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithBigKingImage> {

    @Override
    public Class<BannerWithBigKingImage> getTypeClass() {
        return BannerWithBigKingImage.class;
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithBigKingImage> appliedChanges) {
        return appliedChanges.changed(BannerWithBigKingImage.BIG_KING_IMAGE_HASH);
    }

    @Override
    public boolean needLastChangeReset(AppliedChanges<BannerWithBigKingImage> appliedChanges) {
        return appliedChanges.changed(BannerWithBigKingImage.BIG_KING_IMAGE_HASH);
    }
}
