package ru.yandex.direct.core.entity.banner.type.bigkingimage;

import java.util.Map;
import java.util.Set;

import one.util.streamex.EntryStream;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithBigKingImage;
import ru.yandex.direct.core.entity.banner.model.ImageSize;
import ru.yandex.direct.core.entity.banner.model.ImageType;
import ru.yandex.direct.core.entity.banner.service.validation.BannerImageHashValidator;
import ru.yandex.direct.core.entity.banner.type.image.NewImageSizeValidator;
import ru.yandex.direct.core.entity.pricepackage.model.PricePackage;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.validation.builder.ListItemValidator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@Component
public class BannerWithBigKingImageValidatorProvider {
    public static final Set<ImageSize> FRONTPAGE_VIDEO_ALLOWED_IMAGE_SIZES = Set.of(new ImageSize()
            .withWidth(516)
            .withHeight(272));
    public ListItemValidator<BannerWithBigKingImage, Defect> bannerWithBigKingImageValidator(BannersOperationContainer container,
                                                                                             Set<String> featuresForClient) {
        Map<String, Pair<ImageType, ImageSize>> imageHashes = container.getExistingBigKingImageHashesWithType();
        Map<String, ImageSize> imageSizes = EntryStream.of(imageHashes).mapValues(Pair::getRight).toMap();
        Map<String, ImageType> typedHashes = EntryStream.of(imageHashes).mapValues(Pair::getLeft).toMap();
        return (index, banner) -> {
            PricePackage pricePackage = container.getPricePackage(banner);
            boolean isControlByPackage = pricePackage != null && pricePackage.isFrontpageVideoPackage();
            ModelItemValidationBuilder<BannerWithBigKingImage> vb = ModelItemValidationBuilder.of(banner);
            vb.item(BannerWithBigKingImage.BIG_KING_IMAGE_HASH)
                    .check(isNull(), When.isFalse(
                            !isControlByPackage && featuresForClient.contains(FeatureName.ASSET_BIG_KING_IMAGE.getName())
                            || isControlByPackage && pricePackage.getCampaignOptions().getAllowImage()
                    ))
                    .check(notNull(), When.isTrue(isControlByPackage && pricePackage.getCampaignOptions().getAllowImage()))
                    .checkBy(new BannerImageHashValidator(typedHashes, Set.of(ImageType.REGULAR, ImageType.IMAGE_AD)))
                    .checkBy(new NewImageSizeValidator(imageSizes, FRONTPAGE_VIDEO_ALLOWED_IMAGE_SIZES), When.isTrue(isControlByPackage));
            return vb.getResult();
        };
    }
}
