package ru.yandex.direct.core.entity.banner.type.body;

import java.util.List;
import java.util.Map;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithBodyComputedFromCreative;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;
import ru.yandex.direct.core.entity.banner.type.creative.BannerWithCreativeHelper;

@Component
public class BannerWithBodyComputedFromCreativeAddOperationTypeSupport
        extends AbstractBannerAddOperationTypeSupport<BannerWithBodyComputedFromCreative> {

    private final BannerWithCreativeHelper creativeHelper;

    @Autowired
    public BannerWithBodyComputedFromCreativeAddOperationTypeSupport(
            BannerWithCreativeHelper creativeHelper) {
        this.creativeHelper = creativeHelper;
    }

    @Override
    public Class<BannerWithBodyComputedFromCreative> getTypeClass() {
        return BannerWithBodyComputedFromCreative.class;
    }

    @Override
    public void beforeExecution(BannersAddOperationContainer container,
                                List<BannerWithBodyComputedFromCreative> banners) {
        setBannerBodiesFromCreatives(container, banners);
    }

    private void setBannerBodiesFromCreatives(BannersAddOperationContainer container,
                                              List<BannerWithBodyComputedFromCreative> banners) {
        Map<Long, String> creativeIdToModerationBodiesMap =
                creativeHelper.getCreativesModerationBodies(container.getShard(), banners);
        StreamEx.of(banners)
                .filter(banner -> banner.getCreativeId() != null)
                .forEach(banner ->
                        banner.setBody(creativeIdToModerationBodiesMap.get(banner.getCreativeId())));
    }
}
