package ru.yandex.direct.core.entity.banner.type.body;

import java.util.List;
import java.util.Map;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithBodyComputedFromCreative;
import ru.yandex.direct.core.entity.banner.model.BannerWithCreative;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.core.entity.banner.type.creative.BannerWithCreativeHelper;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.model.BannerWithBody.BODY;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
public class BannerWithBodyComputedFromCreativeUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithBodyComputedFromCreative> {

    private final BannerWithCreativeHelper creativeHelper;

    @Autowired
    public BannerWithBodyComputedFromCreativeUpdateOperationTypeSupport(
            BannerWithCreativeHelper creativeHelper) {
        this.creativeHelper = creativeHelper;
    }

    @Override
    public Class<BannerWithBodyComputedFromCreative> getTypeClass() {
        return BannerWithBodyComputedFromCreative.class;
    }

    @Override
    public void beforeExecution(BannersUpdateOperationContainer container,
                                List<AppliedChanges<BannerWithBodyComputedFromCreative>> changesList) {
        setBannerTitlesFromCreatives(container, changesList);
    }

    private void setBannerTitlesFromCreatives(
            BannersUpdateOperationContainer container,
            List<AppliedChanges<BannerWithBodyComputedFromCreative>> changesList) {
        List<BannerWithCreative> banners = mapList(changesList, AppliedChanges::getModel);
        Map<Long, String> creativeIdToModerationBodiesMap =
                creativeHelper.getCreativesModerationBodies(container.getShard(), banners);
        StreamEx.of(changesList)
                .filter(changes -> changes.getModel().getCreativeId() != null)
                .forEach(changes ->
                        changes.modify(BODY, creativeIdToModerationBodiesMap.get(changes.getModel().getCreativeId())));
    }
}
