package ru.yandex.direct.core.entity.banner.type.body;

import ru.yandex.direct.core.entity.banner.service.validation.BannerTextConstants;

public class BannerWithBodyConstants {

    /**
     * Максимальная длина тела баннера без учёта вхождения шаблонных меток
     * {@link BannerTextConstants#TEMPLATE_MARKER_SYMBOL} (самостоятельный диез учитывается)
     */
    public static final int MAX_LENGTH_BODY = 81;

    /**
     * Максимальная длина тела мобильного баннера без учёта вхождения шаблонных меток
     * {@link BannerTextConstants#TEMPLATE_MARKER_SYMBOL} (самостоятельный диез учитывается)
     */
    public static final int MAX_LENGTH_MOBILE_BODY = 75;

    /**
     * Максимальная длина тела баннера продвижения контента без учёта вхождения шаблонных меток
     * {@link BannerTextConstants#TEMPLATE_MARKER_SYMBOL} (самостоятельный диез учитывается)
     */
    public static final int MAX_LENGTH_CONTENT_PROMOTION_BODY = 200;

    /**
     * Максимальная длина слова в тексте баннера без учёта вхождения шаблонных меток
     * {@link BannerTextConstants#TEMPLATE_MARKER_SYMBOL} (самостоятельный диез учитывается)
     */
    public static final int MAX_LENGTH_BODY_WORD = 23;

    /**
     * Значение body для mc banner'а
     */
    public static final String MC_BANNER_BODY = "picture banner body";

    private BannerWithBodyConstants() {
        // only for static methods
    }
}
