package ru.yandex.direct.core.entity.banner.type.body;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersModerationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithBody;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.service.BannerTextChangeUtil.isBannerBodyChangedSignificantly;

@Component
public class BannerWithBodyUpdateOperationTypeSupport extends AbstractBannerUpdateOperationTypeSupport<BannerWithBody> {

    @Override
    public Class<BannerWithBody> getTypeClass() {
        return BannerWithBody.class;
    }

    @Override
    public boolean needModeration(BannersModerationContainer container,
                                  AppliedChanges<BannerWithBody> appliedChanges) {
        return isBannerBodyChangedSignificantly(appliedChanges);
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithBody> appliedChanges) {
        return appliedChanges.changed(BannerWithBody.BODY);
    }
}
