package ru.yandex.direct.core.entity.banner.type.body;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithBody;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithBodyUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithBody> {

    private final BannerWithBodyValidatorProvider validatorProvider;

    @Autowired
    public BannerWithBodyUpdateValidationTypeSupport(BannerWithBodyValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithBody> getTypeClass() {
        return BannerWithBody.class;
    }

    @Override
    public ValidationResult<List<BannerWithBody>, Defect> validate(
            BannersUpdateOperationContainer container, ValidationResult<List<BannerWithBody>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithBodyValidator(container))
                .getResult();
    }
}
