package ru.yandex.direct.core.entity.banner.type.body;

import java.util.List;

import org.springframework.stereotype.Component;

import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.core.entity.banner.BannerTranslations;
import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithFixedBody;
import ru.yandex.direct.core.entity.banner.model.McBanner;
import ru.yandex.direct.core.entity.banner.model.PerformanceBanner;
import ru.yandex.direct.core.entity.banner.model.PerformanceBannerMain;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;

import static ru.yandex.direct.core.entity.banner.type.body.BannerWithBodyConstants.MC_BANNER_BODY;

@Component
public class BannerWithFixedBodyAddOperationTypeSupport
        extends AbstractBannerAddOperationTypeSupport<BannerWithFixedBody> {

    private final TranslationService translationService;

    public BannerWithFixedBodyAddOperationTypeSupport(TranslationService translationService) {
        this.translationService = translationService;
    }

    @Override
    public Class<BannerWithFixedBody> getTypeClass() {
        return BannerWithFixedBody.class;
    }

    @Override
    public void beforeExecution(BannersAddOperationContainer addContainer, List<BannerWithFixedBody> models) {
        models.forEach(banner -> banner.setBody(generateBody(banner)));
    }

    private String generateBody(BannerWithFixedBody banner) {
        if (banner instanceof PerformanceBanner || banner instanceof PerformanceBannerMain) {
            return translationService.translate(BannerTranslations.INSTANCE.performanceBody());
        } else if (banner instanceof McBanner) {
            return MC_BANNER_BODY;
        } else {
            throw new IllegalArgumentException("Unknown banner type");
        }
    }
}
