package ru.yandex.direct.core.entity.banner.type.body;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithFixedBody;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithFixedBodyUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithFixedBody> {

    private final BannerWithFixedBodyValidatorProvider validatorProvider;

    @Autowired
    public BannerWithFixedBodyUpdateValidationTypeSupport(
            BannerWithFixedBodyValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithFixedBody> getTypeClass() {
        return BannerWithFixedBody.class;
    }

    @Override
    public ValidationResult<List<BannerWithFixedBody>, Defect> validate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<BannerWithFixedBody>, Defect> vr,
            Map<Integer, AppliedChanges<BannerWithFixedBody>> appliedChangesForValidModelChanges) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithFixedBodyUpdateValidator(appliedChangesForValidModelChanges))
                .getResult();
    }
}
