package ru.yandex.direct.core.entity.banner.type.body;

import java.util.Map;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithFixedBody;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.validation.builder.ListItemValidator;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.validation.ValidationUtils.addErrorIfPropertyChanged;
import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;

@Component
public class BannerWithFixedBodyValidatorProvider {

    public Validator<BannerWithFixedBody, Defect> bannerWithFixedBodyAddValidator(
            BannersAddOperationContainer container) {
        return banner -> {
            ModelItemValidationBuilder<BannerWithFixedBody> vb = ModelItemValidationBuilder.of(banner);
            vb.item(BannerWithFixedBody.BODY)
                    .check(isNull());
            return vb.getResult();
        };
    }

    public ListItemValidator<BannerWithFixedBody, Defect> bannerWithFixedBodyUpdateValidator(
            Map<Integer, AppliedChanges<BannerWithFixedBody>> appliedChanges) {
        return (index, banner) -> {
            AppliedChanges<BannerWithFixedBody> bannerChanges = appliedChanges.get(index);
            ModelItemValidationBuilder<BannerWithFixedBody> vb = ModelItemValidationBuilder.of(banner);
            addErrorIfPropertyChanged(bannerChanges, vb, BannerWithFixedBody.BODY);
            return vb.getResult();
        };
    }
}
