package ru.yandex.direct.core.entity.banner.type.bsresync;

import java.util.List;
import java.util.Map;
import java.util.Set;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.type.bsresync.processors.DefaultUpdateOperationBsResyncProcessor;
import ru.yandex.direct.core.entity.banner.type.bsresync.processors.UpdateOperationBsResyncProcessor;
import ru.yandex.direct.model.AppliedChanges;

import static java.util.function.Function.identity;

@Service
public class BannersUpdateBsResyncService {
    private final Map<Class, UpdateOperationBsResyncProcessor> processors;
    private final DefaultUpdateOperationBsResyncProcessor defaultProcessor;

    @Autowired
    public BannersUpdateBsResyncService(List<UpdateOperationBsResyncProcessor> processors,
                                           DefaultUpdateOperationBsResyncProcessor defaultProcessor) {
        this.defaultProcessor = defaultProcessor;

        this.processors = StreamEx.of(processors)
                .remove(defaultProcessor::equals)
                .mapToEntry(x -> x.getProcessedClass(), identity())
                .toMap();
    }

    /**
     * Вычислить баннеры, которые нужно переотправить в БК и изменить у них статус STATUS_BS_SYNCED на NO
     *
     * @param container           - контейнер
     * @param bannerIdsToBsResync - bannerIds полученные из UpdateOperationTypeSupport.needBsResync, для которых
     *                            необходимость переотправки в БК уже определена
     * @param bannerChanges       - список изменений
     */
    public <T extends Banner> void resetBsSyncStatus(
            BannersUpdateOperationContainer container,
            Set<Long> bannerIdsToBsResync,
            List<AppliedChanges<T>> bannerChanges) {

        bannerChanges.forEach(oneChanges ->
                getProcessor(oneChanges).process(oneChanges, bannerIdsToBsResync, container));
    }

    private <T extends Banner> UpdateOperationBsResyncProcessor getProcessor(AppliedChanges<T> bannerChanges) {
        var bannerClass = bannerChanges.getModel().getClass();
        return processors.getOrDefault(bannerClass, defaultProcessor);
    }
}
