package ru.yandex.direct.core.entity.banner.type.bsresync.processors;

import java.util.Set;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.StatusBsSynced.NO;
import static ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields.STATUS_BS_SYNCED;

public abstract class AbstractUpdateOperationBsResyncProcessor<T extends BannerWithSystemFields> implements UpdateOperationBsResyncProcessor<T> {

    @Override
    public void process(AppliedChanges<T> bannerChanges,
                        Set<Long> bannerIdsToBsResync,
                        BannersUpdateOperationContainer container) {


        if (isNeedBsResyncAlreadyComputed(bannerIdsToBsResync, bannerChanges)
                || isBannerNeedBsResyncInternal(bannerChanges, container)) {

            resetStatus(bannerChanges);
        }
    }

    protected void resetStatus(AppliedChanges<T> bannerChanges) {
        bannerChanges.modify(STATUS_BS_SYNCED, NO);
    }

    /**
     * Необходимость переотправки в БК уже могла быть вычислена в UpdateOperationTypeSupport.needBsResync
     */
    private boolean isNeedBsResyncAlreadyComputed(Set<Long> bannerIdsToBsResync,
                                                  AppliedChanges<T> oneChanges) {
        return bannerIdsToBsResync.contains(oneChanges.getModel().getId());
    }

    protected abstract boolean isBannerNeedBsResyncInternal(AppliedChanges<T> bannerChanges,
                                                            BannersUpdateOperationContainer container);
}
