package ru.yandex.direct.core.entity.banner.type.bsresync.processors;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.PerformanceBanner;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.bannerWasDraft;
import static ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.campaignIsDraft;

@Component
public class PerformanceBannerBsResyncProcessor extends AbstractUpdateOperationBsResyncProcessor<PerformanceBanner> {

    @Override
    public Class<PerformanceBanner> getProcessedClass() {
        return PerformanceBanner.class;
    }

    @Override
    protected boolean isBannerNeedBsResyncInternal(AppliedChanges<PerformanceBanner> bannerChanges,
                                                   BannersUpdateOperationContainer container) {

        CommonCampaign campaign = container.getCampaign(bannerChanges.getModel());
        boolean campaignIsNotDraft = !campaignIsDraft(campaign);
        boolean bannerWasDraft = bannerWasDraft(bannerChanges);

        return campaignIsNotDraft && bannerWasDraft && container.getModerationMode().isForceModerate();
    }
}
