package ru.yandex.direct.core.entity.banner.type.button;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerButtonStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithButton;
import ru.yandex.direct.core.entity.banner.model.ButtonAction;
import ru.yandex.direct.core.entity.banner.service.type.add.AbstractBannerAddOperationTypeSupport;

import static ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.isEffectiveSaveDraft;

@Component
public class BannerWithButtonAddOperationTypeSupport
        extends AbstractBannerAddOperationTypeSupport<BannerWithButton> {

    private final BannerWithButtonHelper newBannerWithButtonHelper;

    @Autowired
    public BannerWithButtonAddOperationTypeSupport(BannerWithButtonHelper newBannerWithButtonHelper) {
        this.newBannerWithButtonHelper = newBannerWithButtonHelper;
    }

    @Override
    public Class<BannerWithButton> getTypeClass() {
        return BannerWithButton.class;
    }

    @Override
    public void beforeExecution(BannersAddOperationContainer addContainer, List<BannerWithButton> models) {
        models.forEach(banner -> fillSystemFields(addContainer, banner));
    }

    private void fillSystemFields(BannersAddOperationContainer addContainer, BannerWithButton banner) {
        ButtonAction buttonAction = banner.getButtonAction();
        if (buttonAction != null) {
            if (buttonAction != ButtonAction.CUSTOM_TEXT) {
                banner.withButtonCaption(newBannerWithButtonHelper.translate(buttonAction));
            }

            var effectiveSaveDraft = isEffectiveSaveDraft(addContainer, banner);
            banner.withButtonStatusModerate(effectiveSaveDraft ?
                    BannerButtonStatusModerate.NEW : BannerButtonStatusModerate.READY);
        }
    }
}
