package ru.yandex.direct.core.entity.banner.type.button;

import java.util.Set;

import com.google.common.collect.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.core.entity.banner.model.BannerWithButton;
import ru.yandex.direct.core.entity.banner.model.ButtonAction;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.model.AppliedChanges;

import static java.util.Collections.singleton;

@Component
public class BannerWithButtonHelper {

    /**
     * Список поддерживаемых действий по кнопке, добавлять после появления переводов
     */
    private static final Set<ButtonAction> ALLOWED_BUTTON_ACTIONS =
            Sets.immutableEnumSet(
                    ButtonAction.GO_TO_WEBSITE,
                    ButtonAction.MORE,
                    ButtonAction.GET_PRICE,
                    ButtonAction.GET_OFFER,
                    ButtonAction.APPLY,
                    ButtonAction.BOOK,
                    ButtonAction.REGISTER,
                    ButtonAction.SUBSCRIBE,
                    ButtonAction.CHOOSE,
                    ButtonAction.TRY,
                    ButtonAction.WATCH,
                    ButtonAction.TURN_ON,
                    ButtonAction.LISTEN,
                    ButtonAction.PLAY,
                    ButtonAction.START,
                    ButtonAction.BUY,
                    ButtonAction.DOWNLOAD,
                    ButtonAction.INSTALL
            );


    private final TranslationService translationService;

    @Autowired
    public BannerWithButtonHelper(TranslationService translationService) {
        this.translationService = translationService;
    }

    public String translate(ButtonAction buttonAction) {
            return translationService.translate(buttonAction.getDescription());
    }

    public Set<ButtonAction> getAllowedButtonActions(Set<String> clientEnabledFeatures) {
        if (clientEnabledFeatures.contains(FeatureName.ASSET_BUTTON_CUSTOM_TEXT.getName())) {
            return Sets.union(ALLOWED_BUTTON_ACTIONS, singleton(ButtonAction.CUSTOM_TEXT));
        }

        return ALLOWED_BUTTON_ACTIONS;
    }

    public boolean isButtonChanged(AppliedChanges<? extends BannerWithButton> appliedChanges) {
        return appliedChanges.changed(BannerWithButton.BUTTON_ACTION) ||
                appliedChanges.changed(BannerWithButton.BUTTON_CAPTION) ||
                appliedChanges.changed(BannerWithButton.BUTTON_HREF);
    }
}
