package ru.yandex.direct.core.entity.banner.type.button;

import java.util.Collection;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.util.mysql.MySQLDSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerButtonStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithButton;
import ru.yandex.direct.core.entity.banner.model.ButtonAction;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractFlatRelatedEntityUpsertRepositoryTypeSupport;
import ru.yandex.direct.dbschema.ppc.Tables;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerButtonsRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.model.ModelProperty;

import static ru.yandex.direct.dbschema.ppc.tables.BannerButtons.BANNER_BUTTONS;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@Component
@ParametersAreNonnullByDefault
public class BannerWithButtonRepositoryTypeSupport
        extends AbstractFlatRelatedEntityUpsertRepositoryTypeSupport
        <BannerWithButton, BannerButtonsRecord> {

    private static final Set<ModelProperty> MUTABLE_PROPERTIES = Set.of(
            BannerWithButton.BUTTON_ACTION,
            BannerWithButton.BUTTON_CAPTION,
            BannerWithButton.BUTTON_HREF,
            BannerWithButton.BUTTON_STATUS_MODERATE
    );

    @Autowired
    public BannerWithButtonRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider, BANNER_BUTTONS.BID, createMapper());
    }

    @Override
    protected boolean isAddEntity(BannerWithButton banner) {
        return banner.getButtonAction() != null;
    }

    @Override
    protected boolean isDeleteEntity(AppliedChanges<BannerWithButton> appliedChanges) {
        return appliedChanges.deleted(BannerWithButton.BUTTON_ACTION);
    }

    @Override
    protected boolean isUpsertEntity(AppliedChanges<BannerWithButton> appliedChanges) {
        return !isDeleteEntity(appliedChanges) && MUTABLE_PROPERTIES.stream().anyMatch(appliedChanges::changed);
    }

    @Override
    protected void upsertEntity(
            DSLContext context,
            Collection<BannerWithButton> banners) {
        var insertHelper = new InsertHelper<>(context, BANNER_BUTTONS);
        insertHelper.addAll(getJooqMapper(), banners);
        insertHelper.onDuplicateKeyUpdate()
                .set(BANNER_BUTTONS.CAPTION, MySQLDSL.values(BANNER_BUTTONS.CAPTION))
                .set(BANNER_BUTTONS.KEY, MySQLDSL.values(BANNER_BUTTONS.KEY))
                .set(BANNER_BUTTONS.STATUS_MODERATE, MySQLDSL.values(BANNER_BUTTONS.STATUS_MODERATE))
                .set(BANNER_BUTTONS.HREF, MySQLDSL.values(BANNER_BUTTONS.HREF));
        insertHelper.executeIfRecordsAdded();
    }

    @Override
    public Class<BannerWithButton> getTypeClass() {
        return BannerWithButton.class;
    }

    private static JooqMapper<BannerWithButton> createMapper() {
        return JooqMapperBuilder.<BannerWithButton>builder()
                .writeField(BANNER_BUTTONS.BID, fromProperty(BannerWithButton.ID))
                .map(property(BannerWithButton.BUTTON_CAPTION, BANNER_BUTTONS.CAPTION))
                .map(property(BannerWithButton.BUTTON_HREF, BANNER_BUTTONS.HREF))
                .map(convertibleProperty(BannerWithButton.BUTTON_ACTION, BANNER_BUTTONS.KEY,
                        ButtonAction::fromSource,
                        ButtonAction::toSource))
                .map(convertibleProperty(BannerWithButton.BUTTON_STATUS_MODERATE,
                        Tables.BANNER_BUTTONS.STATUS_MODERATE,
                        BannerButtonStatusModerate::fromSource,
                        BannerButtonStatusModerate::toSource))
                .build();
    }
}
