package ru.yandex.direct.core.entity.banner.type.button;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithButton;
import ru.yandex.direct.core.entity.banner.model.ButtonAction;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class BannerWithButtonUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithButton> {

    private final BannerWithButtonHelper newBannerWithButtonHelper;

    @Autowired
    public BannerWithButtonUpdateOperationTypeSupport(BannerWithButtonHelper newBannerWithButtonHelper) {
        this.newBannerWithButtonHelper = newBannerWithButtonHelper;
    }

    @Override
    public Class<BannerWithButton> getTypeClass() {
        return BannerWithButton.class;
    }

    @Override
    public void beforeExecution(BannersUpdateOperationContainer updateContainer,
                                List<AppliedChanges<BannerWithButton>> appliedChanges) {
        for (AppliedChanges<BannerWithButton> changes : appliedChanges) {
            ButtonAction buttonAction = changes.getModel().getButtonAction();
            if (buttonAction != null && buttonAction != ButtonAction.CUSTOM_TEXT) {
                String caption = newBannerWithButtonHelper.translate(buttonAction);
                changes.modify(BannerWithButton.BUTTON_CAPTION, caption);
            }
        }
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithButton> appliedChanges) {
        return newBannerWithButtonHelper.isButtonChanged(appliedChanges);
    }

    @Override
    public boolean needLastChangeReset(AppliedChanges<BannerWithButton> appliedChanges) {
        return newBannerWithButtonHelper.isButtonChanged(appliedChanges);
    }
}
