package ru.yandex.direct.core.entity.banner.type.button.moderation;

import java.util.List;

import org.jooq.DSLContext;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerButtonStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithButton;
import ru.yandex.direct.core.entity.banner.model.BannerWithButtonModeration;
import ru.yandex.direct.core.entity.banner.type.button.BannerWithButtonHelper;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.service.BannerModerationUtils.bannerBecameDraft;

@Component
public class DefaultBannerWithButtonModerationProcessor implements BannerWithButtonModerationProcessor {

    private final BannerWithButtonHelper newBannerWithButtonHelper;

    public DefaultBannerWithButtonModerationProcessor(BannerWithButtonHelper newBannerWithButtonHelper) {
        this.newBannerWithButtonHelper = newBannerWithButtonHelper;
    }

    @Override
    public Class<BannerWithButtonModeration> getProcessedClass() {
        return BannerWithButtonModeration.class;
    }

    @Override
    public void process(
            DSLContext dsl,
            BannerAdditionalActionsContainer additionalActionsContainer, BannersUpdateOperationContainer container,
            List<AppliedChanges<BannerWithButtonModeration>> appliedChanges) {

        for (AppliedChanges<BannerWithButtonModeration> changes : appliedChanges) {
            if (!changes.hasActuallyChangedProps() && container.getModerationMode().isDefault()) {
                continue;
            }

            if (changes.getNewValue(BannerWithButton.BUTTON_ACTION) == null) {
                continue;
            }

            if (bannerBecameDraft(changes)) {
                changes.modify(BannerWithButton.BUTTON_STATUS_MODERATE, BannerButtonStatusModerate.NEW);
                continue;
            }

            if (changes.getNewValue(BannerWithButtonModeration.STATUS_MODERATE) == BannerStatusModerate.READY ||
                    newBannerWithButtonHelper.isButtonChanged(changes)) {

                changes.modify(BannerWithButton.BUTTON_STATUS_MODERATE, BannerButtonStatusModerate.READY);
            }
        }
    }
}
