package ru.yandex.direct.core.entity.banner.type.button.moderation;

import java.util.List;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannerAdditionalActionsContainer;
import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithButtonModeration;
import ru.yandex.direct.core.entity.banner.service.moderation.BannerWithChildrenModerationProvider;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
public class DefaultBannerWithButtonModerationUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithButtonModeration> {

    private final BannerWithChildrenModerationProvider<BannerWithButtonModeration> provider;

    @Autowired
    public DefaultBannerWithButtonModerationUpdateOperationTypeSupport(
            List<BannerWithButtonModerationProcessor> processors) {

        this.provider = new BannerWithChildrenModerationProvider<>(
                DefaultBannerWithButtonModerationProcessor.class,
                processors);
    }

    @Override
    public Class<BannerWithButtonModeration> getTypeClass() {
        return BannerWithButtonModeration.class;
    }

    @Override
    public void beforeExecutionInTransaction(
            DSLContext dsl,
            BannerAdditionalActionsContainer additionalActionsContainer,
            BannersUpdateOperationContainer updateContainer,
            List<AppliedChanges<BannerWithButtonModeration>> appliedChanges) {
        provider.process(dsl, additionalActionsContainer, updateContainer, appliedChanges);
    }
}
