package ru.yandex.direct.core.entity.banner.type.button.validation;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithButton;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithButtonUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithButton> {
    private final BannerWithButtonValidatorProvider validatorProvider;

    @Autowired
    public BannerWithButtonUpdateValidationTypeSupport(BannerWithButtonValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithButton> getTypeClass() {
        return BannerWithButton.class;
    }

    @Override
    public ValidationResult<List<BannerWithButton>, Defect> validate(
            BannersUpdateOperationContainer container, ValidationResult<List<BannerWithButton>, Defect> vr) {

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithButtonValidator(container))
                .getResult();
    }
}
