package ru.yandex.direct.core.entity.banner.type.button.validation;

import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithButton;
import ru.yandex.direct.core.entity.banner.model.ButtonAction;
import ru.yandex.direct.core.entity.banner.type.button.BannerWithButtonHelper;
import ru.yandex.direct.core.entity.banner.type.href.BannerHrefValidator;
import ru.yandex.direct.validation.builder.ListItemValidator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.defect.CommonDefects;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.isEqual;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@Component
public class BannerWithButtonValidatorProvider {
    private final BannerWithButtonHelper newBannerWithButtonHelper;
    private final TranslationService translationService;

    @Autowired
    public BannerWithButtonValidatorProvider(BannerWithButtonHelper newBannerWithButtonHelper,
                                             TranslationService translationService) {
        this.newBannerWithButtonHelper = newBannerWithButtonHelper;
        this.translationService = translationService;
    }

    public ListItemValidator<BannerWithButton, Defect> bannerWithButtonValidator(
            BannersOperationContainer container) {

        Set<ButtonAction> allowedButtonActions =
                newBannerWithButtonHelper.getAllowedButtonActions(container.getClientEnabledFeatures());

        return (index, banner) -> {
            ModelItemValidationBuilder<BannerWithButton> vb = ModelItemValidationBuilder.of(banner);
            if (banner.getButtonAction() == null) {
                return vb.getResult();
            }

            vb.item(BannerWithButton.BUTTON_ACTION)
                    .checkBy(new ButtonActionValidator(allowedButtonActions));

            boolean customText = banner.getButtonAction() == ButtonAction.CUSTOM_TEXT;
            String translatedText = null;

            if (!customText) {
                translatedText = translationService.translate(banner.getButtonAction().getDescription());
            }

            /* В случае CUSTOM_TEXT этот заголовок заполняется данными из базы,
               когда пользователь кнопку не трогает, а она уже есть.
               Или должен быть null, когда приходит от пользователя
             */
            vb.item(BannerWithButton.BUTTON_CAPTION)
                    .checkBy(new ButtonCaptionValidator(), When.isTrue(customText))
                    .check(isEqual(translatedText, CommonDefects.isNull()),
                            When.valueIs(e -> !customText && e != null));

            vb.item(BannerWithButton.BUTTON_HREF)
                    .check(notNull())
                    .checkBy(new BannerHrefValidator());

            return vb.getResult();
        };
    }
}
