package ru.yandex.direct.core.entity.banner.type.button.validation;

import java.util.Set;

import ru.yandex.direct.core.entity.banner.model.ButtonAction;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.unsupportedButtonAction;

public class ButtonActionValidator implements Validator<ButtonAction, Defect> {

    private Set<ButtonAction> allowedButtonActions;

    public ButtonActionValidator(Set<ButtonAction> allowedButtonActions) {
        this.allowedButtonActions = allowedButtonActions;
    }

    @Override
    public ValidationResult<ButtonAction, Defect> apply(ButtonAction buttonAction) {
        ItemValidationBuilder<ButtonAction, Defect> vb = ItemValidationBuilder.of(buttonAction);
        vb.check(Constraint.fromPredicate(allowedButtonActions::contains, unsupportedButtonAction()));
        return vb.getResult();
    }
}
