package ru.yandex.direct.core.entity.banner.type.button.validation;

import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.constraint.StringConstraints;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.restrictedCharsInField;
import static ru.yandex.direct.core.entity.banner.type.button.BannerWithButtonConstants.CAPTION_ALLOWED_REGEX;
import static ru.yandex.direct.core.entity.banner.type.button.BannerWithButtonConstants.CAPTION_MAX_LENGTH;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.StringConstraints.notBlank;

public class ButtonCaptionValidator implements Validator<String, Defect> {

    @Override
    public ValidationResult<String, Defect> apply(String buttonCaption) {
        ItemValidationBuilder<String, Defect> vb = ItemValidationBuilder.of(buttonCaption);
        vb.check(notNull())
                .check(notBlank())
                .check(Constraint.fromPredicate(caption -> caption.matches(CAPTION_ALLOWED_REGEX),
                        restrictedCharsInField()), When.isValid())
                .check(StringConstraints.maxStringLength(CAPTION_MAX_LENGTH));

        return vb.getResult();
    }
}
