package ru.yandex.direct.core.entity.banner.type.callouts;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithCallouts;
import ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class BannerWithCalloutsAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithCallouts> {

    private final BannerWithCalloutsValidatorProvider validatorProvider;

    @Autowired
    public BannerWithCalloutsAddValidationTypeSupport(BannerWithCalloutsValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public ValidationResult<List<BannerWithCallouts>, Defect> validate(
            BannersAddOperationContainer container,
            ValidationResult<List<BannerWithCallouts>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.validator(container,
                        BannerDefects::maxAdExtensionsExceeded,
                        vr.getValue()))
                .getResult();
    }

    @Override
    public Class<BannerWithCallouts> getTypeClass() {
        return BannerWithCallouts.class;
    }

}
