package ru.yandex.direct.core.entity.banner.type.callouts;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithCallouts;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

import static ru.yandex.direct.core.entity.banner.type.callouts.BannerWithCalloutsUtils.isBannerCalloutsChanged;

@Component
@ParametersAreNonnullByDefault
public class BannerWithCalloutsUpdateOperationTypeSupport
        extends AbstractBannerUpdateOperationTypeSupport<BannerWithCallouts> {

    @Override
    public Class<BannerWithCallouts> getTypeClass() {
        return BannerWithCallouts.class;
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithCallouts> appliedChanges) {
        return isBannerCalloutsChanged(appliedChanges);
    }

    @Override
    public boolean needLastChangeReset(AppliedChanges<BannerWithCallouts> appliedChanges) {
        return isBannerCalloutsChanged(appliedChanges);
    }

}
