package ru.yandex.direct.core.entity.banner.type.callouts;

import java.util.List;
import java.util.Objects;
import java.util.Set;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.banner.model.BannerWithCallouts;
import ru.yandex.direct.model.AppliedChanges;

import static java.util.Collections.emptySet;
import static java.util.function.Function.identity;
import static ru.yandex.direct.utils.CommonUtils.nvl;
import static ru.yandex.direct.utils.FunctionalUtils.listToSet;

@ParametersAreNonnullByDefault
public class BannerWithCalloutsUtils {
    private BannerWithCalloutsUtils() {
    }

    public static boolean isBannerCalloutsChanged(@Nonnull AppliedChanges<? extends BannerWithCallouts> ac) {
        Set<Long> oldValue = normalizeCalloutIds(ac.getOldValue(BannerWithCallouts.CALLOUT_IDS));
        Set<Long> newValue = normalizeCalloutIds(ac.getNewValue(BannerWithCallouts.CALLOUT_IDS));
        return !Objects.equals(oldValue, newValue);
    }

    private static Set<Long> normalizeCalloutIds(@Nullable List<Long> calloutIds) {
        return nvl(listToSet(calloutIds, identity()), emptySet());
    }
}
