package ru.yandex.direct.core.entity.banner.type.campaignid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithCampaignId;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractBannerDefaultRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static java.util.function.Function.identity;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

@Component
public class BannerWithCampaignIdRepositoryTypeSupport
        extends AbstractBannerDefaultRepositoryTypeSupport<BannerWithCampaignId> {

    @Autowired
    public BannerWithCampaignIdRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider, BannerWithCampaignId.CAMPAIGN_ID, BANNERS.CID, identity(),
                identity());
    }

    @Override
    public Class<BannerWithCampaignId> getTypeClass() {
        return BannerWithCampaignId.class;
    }
}
