package ru.yandex.direct.core.entity.banner.type.contentpromo;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbschema.ppc.enums.BannersStatusmoderate;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.tables.BannersContentPromotion.BANNERS_CONTENT_PROMOTION;

@Repository
public class BannerWithContentPromotionRepository {

    protected final DslContextProvider dslContextProvider;

    @Autowired
    public BannerWithContentPromotionRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    /**
     * Получает наборы id-шников баннеров (не черновиков) по id контента, к ним привязанного. Нужно, например,
     * для обновления баннеров при обновлении контента.
     *
     * @param shard      обрабатываемый шард
     * @param contentIds набор id контента
     * @return мапа (id контента) - (список id баннеров (не черновиков), к которому он привязано)
     */
    public Map<Long, List<Long>> getNonDraftBannerIdsByContentIds(int shard, List<Long> contentIds) {
        return dslContextProvider.ppc(shard)
                .select(BANNERS_CONTENT_PROMOTION.CONTENT_PROMOTION_ID, BANNERS_CONTENT_PROMOTION.BID)
                .from(BANNERS_CONTENT_PROMOTION)
                .join(BANNERS).on(BANNERS.BID.eq(BANNERS_CONTENT_PROMOTION.BID))
                .where(BANNERS_CONTENT_PROMOTION.CONTENT_PROMOTION_ID.in(contentIds))
                .and(BANNERS.STATUS_MODERATE.ne(BannersStatusmoderate.New))
                .fetchGroups(BANNERS_CONTENT_PROMOTION.CONTENT_PROMOTION_ID, BANNERS_CONTENT_PROMOTION.BID);
    }
}
