package ru.yandex.direct.core.entity.banner.type.contentpromo;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.JoinType;
import org.jooq.Record;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithContentPromotion;
import ru.yandex.direct.core.entity.banner.repository.type.AbstractBannerRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;
import ru.yandex.direct.jooqmapper.JooqMapperBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelperAggregator;
import ru.yandex.direct.jooqmapperhelper.UpdateHelperAggregator;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.multitype.entity.JoinQuery;

import static ru.yandex.direct.core.entity.banner.model.Banner.ID;
import static ru.yandex.direct.core.entity.banner.model.BannerWithContentPromotion.CONTENT_PROMOTION_ID;
import static ru.yandex.direct.core.entity.banner.model.BannerWithContentPromotion.VISIT_URL;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_CONTENT_PROMOTION;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;
import static ru.yandex.direct.jooqmapper.write.WriterBuilders.fromProperty;

@Component
@ParametersAreNonnullByDefault
public class BannerWithContentPromotionRepositoryTypeSupport
        extends AbstractBannerRepositoryTypeSupport<BannerWithContentPromotion> {

    private final JooqMapper<BannerWithContentPromotion> jooqMapper;

    @Autowired
    public BannerWithContentPromotionRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
        jooqMapper = createMapper();
    }

    @Override
    public Class<BannerWithContentPromotion> getTypeClass() {
        return BannerWithContentPromotion.class;
    }

    @Override
    public Collection<Field<?>> getFields() {
        return jooqMapper.getFieldsToRead();
    }

    @Override
    public List<JoinQuery> joinQuery() {
        return List.of(new JoinQuery(
                BANNERS_CONTENT_PROMOTION,
                JoinType.LEFT_OUTER_JOIN,
                BANNERS_CONTENT_PROMOTION.BID.eq(BANNERS.BID)
        ));
    }

    @Override
    public <M extends BannerWithContentPromotion> void fillFromRecord(M banner, Record record) {
        jooqMapper.fromDb(record, banner);
    }

    @Override
    public void pushToInsert(InsertHelperAggregator insertHelperAggregator, BannerWithContentPromotion banner) {
        insertHelperAggregator.getOrCreate(BANNERS_CONTENT_PROMOTION)
                .add(jooqMapper, banner);
    }

    @Override
    public void processUpdate(UpdateHelperAggregator updateHelperAggregator,
                              Collection<AppliedChanges<BannerWithContentPromotion>> appliedChanges) {
        updateHelperAggregator.getOrCreate(BANNERS_CONTENT_PROMOTION.BID)
                .processUpdateAll(jooqMapper, appliedChanges);
    }

    private JooqMapper<BannerWithContentPromotion> createMapper() {
        return JooqMapperBuilder.<BannerWithContentPromotion>builder()
                .writeField(BANNERS_CONTENT_PROMOTION.BID, fromProperty(ID))
                .map(property(CONTENT_PROMOTION_ID, BANNERS_CONTENT_PROMOTION.CONTENT_PROMOTION_ID))
                .map(property(VISIT_URL, BANNERS_CONTENT_PROMOTION.VISIT_URL))
                .build();
    }
}
