package ru.yandex.direct.core.entity.banner.type.contentpromo;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersModerationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithContentPromotion;
import ru.yandex.direct.core.entity.banner.service.type.update.AbstractBannerUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
public class BannerWithContentPromotionUpdateOperationTypeSupport extends AbstractBannerUpdateOperationTypeSupport<BannerWithContentPromotion> {

    @Override
    public Class<BannerWithContentPromotion> getTypeClass() {
        return BannerWithContentPromotion.class;
    }

    @Override
    public boolean needModeration(BannersModerationContainer container,
                                  AppliedChanges<BannerWithContentPromotion> appliedChanges) {
        return isFieldsChanged(appliedChanges);
    }

    @Override
    public boolean needBsResync(AppliedChanges<BannerWithContentPromotion> appliedChanges) {
        return isFieldsChanged(appliedChanges);
    }

    private boolean isFieldsChanged(AppliedChanges<BannerWithContentPromotion> appliedChanges) {
        return appliedChanges.changed(BannerWithContentPromotion.CONTENT_PROMOTION_ID)
                || appliedChanges.changed(BannerWithContentPromotion.VISIT_URL);
    }
}
