package ru.yandex.direct.core.entity.banner.type.contentpromo;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersUpdateOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithContentPromotion;
import ru.yandex.direct.core.entity.banner.service.validation.type.update.AbstractBannerUpdateValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

// todo как не валидировать баннеры, не прошедшие превалидацию?
@Component
public class BannerWithContentPromotionUpdateValidationTypeSupport
        extends AbstractBannerUpdateValidationTypeSupport<BannerWithContentPromotion> {

    private final BannerWithContentPromotionValidatorProvider validatorProvider;

    @Autowired
    public BannerWithContentPromotionUpdateValidationTypeSupport(
            BannerWithContentPromotionValidatorProvider validatorProvider) {
        this.validatorProvider = validatorProvider;
    }

    @Override
    public Class<BannerWithContentPromotion> getTypeClass() {
        return BannerWithContentPromotion.class;
    }

    @Override
    public ValidationResult<List<BannerWithContentPromotion>, Defect> validate(
            BannersUpdateOperationContainer container,
            ValidationResult<List<BannerWithContentPromotion>, Defect> vr) {

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.bannerWithContentPromotionValidator(container, vr.getValue()))
                .getResult();
    }
}
