package ru.yandex.direct.core.entity.banner.type.contentpromo;

import java.util.List;
import java.util.Map;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdgroupType;
import ru.yandex.direct.core.entity.banner.container.BannersOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithContentPromotion;
import ru.yandex.direct.core.entity.contentpromotion.model.ContentPromotionContent;
import ru.yandex.direct.core.entity.contentpromotion.repository.ContentPromotionRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.model.BannerWithContentPromotion.CONTENT_PROMOTION_ID;
import static ru.yandex.direct.core.entity.banner.model.BannerWithContentPromotion.VISIT_URL;
import static ru.yandex.direct.core.entity.banner.type.contentpromo.ContentPromotionIdValidator.contentPromotionIdValidator;
import static ru.yandex.direct.core.entity.banner.type.contentpromo.VisitUrlValidator.visitUrlValidator;
import static ru.yandex.direct.utils.FunctionalUtils.listToMap;

@Component
public class BannerWithContentPromotionValidatorProvider {

    private final ContentPromotionRepository contentPromotionRepository;

    @Autowired
    public BannerWithContentPromotionValidatorProvider(
            ContentPromotionRepository contentPromotionRepository) {
        this.contentPromotionRepository = contentPromotionRepository;
    }

    public Validator<BannerWithContentPromotion, Defect> bannerWithContentPromotionValidator(
            BannersOperationContainer container, List<BannerWithContentPromotion> unvalidatedBanners) {

        Map<Long, ContentPromotionContent> contents =
                getClientContentsForValidation(container.getClientId(), unvalidatedBanners);

        return banner -> {
            ContentPromotionAdgroupType contentPromotionAdgroupType = container.getContentPromotionAdGroupType(banner);
            ContentPromotionContent content = contents.get(banner.getContentPromotionId());

            ModelItemValidationBuilder<BannerWithContentPromotion> builder =
                    ModelItemValidationBuilder.of(banner);

            builder.item(CONTENT_PROMOTION_ID)
                    .checkBy(contentPromotionIdValidator(contentPromotionAdgroupType, content));

            builder.item(VISIT_URL)
                    .checkBy(visitUrlValidator(contentPromotionAdgroupType));

            return builder.getResult();
        };
    }

    private Map<Long, ContentPromotionContent> getClientContentsForValidation(
            ClientId clientId, List<BannerWithContentPromotion> unvalidatedBanners) {

        List<Long> contentIds = StreamEx.of(unvalidatedBanners)
                .nonNull()
                .map(BannerWithContentPromotion::getContentPromotionId)
                .nonNull()
                .filter(id -> id > 0)
                .toList();

        List<ContentPromotionContent> contents = contentPromotionRepository.getContentPromotion(clientId, contentIds);
        return listToMap(contents, ContentPromotionContent::getId);
    }
}
