package ru.yandex.direct.core.entity.banner.type.contentpromo;

import java.util.Set;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdgroupType;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.DefaultValidator;

import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;
import static ru.yandex.direct.validation.constraint.StringConstraints.notBlank;
import static ru.yandex.direct.validation.constraint.StringConstraints.validHref;

public class VisitUrlValidator implements DefaultValidator<String> {
    private static final Set<ContentPromotionAdgroupType> TYPES_WITH_VISIT_URL_FORBIDDEN =
            Set.of(ContentPromotionAdgroupType.SERVICE, ContentPromotionAdgroupType.EDA);

    // если null, значит указанная в баннере группа не найдена (может быть только при создании баннера)
    private final ContentPromotionAdgroupType contentPromotionAdgroupType;

    private final boolean forbidden;

    private VisitUrlValidator(ContentPromotionAdgroupType contentPromotionAdgroupType) {
        this.contentPromotionAdgroupType = contentPromotionAdgroupType;
        // невозможно провалидировать дополнительную ссылку, когда тип контента группы неизвестен.
        // эта проблема должна быть поймана в другом месте.
        this.forbidden = contentPromotionAdgroupType != null &&
                TYPES_WITH_VISIT_URL_FORBIDDEN.contains(contentPromotionAdgroupType);
    }

    public static VisitUrlValidator visitUrlValidator(
            @Nullable ContentPromotionAdgroupType contentPromotionAdgroupType) {
        return new VisitUrlValidator(contentPromotionAdgroupType);
    }

    @Override
    public ValidationResult<String, Defect> apply(String visitUrl) {
        if (contentPromotionAdgroupType == null) {
            return new ValidationResult<>(visitUrl);
        }

        ItemValidationBuilder<String, Defect> builder = ItemValidationBuilder.of(visitUrl);

        if (forbidden) {
            builder.check(isNull());
        } else {
            builder
                    .check(notBlank())
                    .check(validHref());
        }

        return builder.getResult();
    }
}
