package ru.yandex.direct.core.entity.banner.type.creative;

import java.util.Map;
import java.util.Set;

import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.model.old.OldBanner;
import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.creative.model.CreativeType;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.type.creative.BannerWithCreativeConstraints.isClientHasCreative;
import static ru.yandex.direct.core.entity.banner.type.creative.BannerWithCreativeConstraints.isCreativeTypeCorrespondTo;
import static ru.yandex.direct.core.entity.banner.type.creative.BannerWithCreativeUtils.getAllowedCreativeTypesByClass;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.validId;

public class BannerCreativeValidator implements Validator<Long, Defect> {

    private final Map<Long, Creative> clientCreativesByIds;
    private final Set<CreativeType> allowedCreativeTypes;
    private final Defect<Void> clientHasCreativeOverrideDefect;
    private final Defect<Void> isCreativeTypeCorrespondToOverrideDefect;
    private final Boolean creativeRequired;

    private BannerCreativeValidator(Map<Long, Creative> clientCreativesByIds,
                                    Class<? extends Banner> newBannerClass,
                                    Class<? extends OldBanner> oldBannerClass,
                                    Defect<Void> clientHasCreativeOverrideDefect,
                                    Defect<Void> isCreativeTypeCorrespondToOverrideDefect,
                                    Boolean creativeRequired) {
        this(clientCreativesByIds, getAllowedCreativeTypesByClass(newBannerClass, oldBannerClass),
                clientHasCreativeOverrideDefect, isCreativeTypeCorrespondToOverrideDefect, creativeRequired);
    }

    private BannerCreativeValidator(Map<Long, Creative> clientCreativesByIds,
                                    Set<CreativeType> allowedCreativeTypes,
                                    Defect<Void> clientHasCreativeOverrideDefect,
                                    Defect<Void> isCreativeTypeCorrespondToOverrideDefect,
                                    Boolean creativeRequired) {
        this.clientCreativesByIds = clientCreativesByIds;
        this.clientHasCreativeOverrideDefect = clientHasCreativeOverrideDefect;
        this.isCreativeTypeCorrespondToOverrideDefect = isCreativeTypeCorrespondToOverrideDefect;
        this.creativeRequired = creativeRequired;
        this.allowedCreativeTypes = allowedCreativeTypes;
    }

    public static BannerCreativeValidator requiredCreativeNewBannerValidator(
            Map<Long, Creative> clientCreativesByIds,
            Class<? extends Banner> newBannerClass,
            Defect<Void> clientHasCreativeOverrideDefect,
            Defect<Void> isCreativeTypeCorrespondToOverrideDefect) {

        return new BannerCreativeValidator(
                clientCreativesByIds,
                newBannerClass,
                null,
                clientHasCreativeOverrideDefect,
                isCreativeTypeCorrespondToOverrideDefect,
                true
        );
    }

    public static BannerCreativeValidator optionalCreativeNewBannerValidator(
            Map<Long, Creative> clientCreativesByIds,
            Class<? extends Banner> newBannerClass,
            Defect<Void> clientHasCreativeOverrideDefect,
            Defect<Void> isCreativeTypeCorrespondToOverrideDefect) {

        return new BannerCreativeValidator(
                clientCreativesByIds,
                newBannerClass,
                null,
                clientHasCreativeOverrideDefect,
                isCreativeTypeCorrespondToOverrideDefect,
                false
        );
    }

    public static BannerCreativeValidator optionalCreativeNewBannerValidator(
            Map<Long, Creative> clientCreativesByIds,
            Set<CreativeType> allowedCreativeTypes,
            Defect<Void> clientHasCreativeOverrideDefect,
            Defect<Void> isCreativeTypeCorrespondToOverrideDefect) {

        return new BannerCreativeValidator(
                clientCreativesByIds,
                allowedCreativeTypes,
                clientHasCreativeOverrideDefect,
                isCreativeTypeCorrespondToOverrideDefect,
                false
        );
    }

    public static BannerCreativeValidator requiredCreativeNewBannerValidator(
            Map<Long, Creative> clientCreativesByIds,
            Class<? extends Banner> newBannerClass) {

        return new BannerCreativeValidator(
                clientCreativesByIds,
                newBannerClass,
                null,
                null,
                null,
                true
        );
    }

    @Override
    public ValidationResult<Long, Defect> apply(Long creativeId) {
        ItemValidationBuilder<Long, Defect> builder = ItemValidationBuilder.of(creativeId);

        builder
                .check(notNull(), When.isTrue(creativeRequired))
                .check(validId(), When.isValid())
                .check(isClientHasCreative(clientCreativesByIds.keySet()), clientHasCreativeOverrideDefect,
                        When.isValid())
                .check(isCreativeTypeCorrespondTo(allowedCreativeTypes, clientCreativesByIds),
                        isCreativeTypeCorrespondToOverrideDefect, When.isValid());

        return builder.getResult();
    }
}
