package ru.yandex.direct.core.entity.banner.type.creative;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.container.BannersAddOperationContainer;
import ru.yandex.direct.core.entity.banner.model.BannerWithCreative;
import ru.yandex.direct.core.entity.banner.service.validation.type.add.AbstractBannerAddValidationTypeSupport;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class BannerWithCreativeAddValidationTypeSupport
        extends AbstractBannerAddValidationTypeSupport<BannerWithCreative> {

    private final BannerWithCreativeValidationContainerFactory creativeValidationContainerFactory;
    private final BannerWithCreativeValidatorProvider validatorProvider;

    @Autowired
    public BannerWithCreativeAddValidationTypeSupport(
            BannerWithCreativeValidationContainerFactory creativeValidationContainerFactory,
            BannerWithCreativeValidatorProvider validatorProvider) {

        this.creativeValidationContainerFactory = creativeValidationContainerFactory;
        this.validatorProvider = validatorProvider;
    }


    @Override
    public Class<BannerWithCreative> getTypeClass() {
        return BannerWithCreative.class;
    }

    @Override
    public ValidationResult<List<BannerWithCreative>, Defect> validate(BannersAddOperationContainer validationContainer,
                                                                       ValidationResult<List<BannerWithCreative>, Defect> vr) {

        BannerWithCreativeValidationContainer creativeValidationContainer =
                creativeValidationContainerFactory.create(validationContainer, vr.getValue());

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validatorProvider.creativeValidator(creativeValidationContainer))
                .getResult();
    }

}
