package ru.yandex.direct.core.entity.banner.type.creative;

import java.util.Map;
import java.util.Set;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;

import ru.yandex.direct.core.entity.banner.model.Banner;
import ru.yandex.direct.core.entity.banner.model.CpcVideoBanner;
import ru.yandex.direct.core.entity.banner.model.CpmAudioBanner;
import ru.yandex.direct.core.entity.banner.model.CpmBanner;
import ru.yandex.direct.core.entity.banner.model.CpmGeoPinBanner;
import ru.yandex.direct.core.entity.banner.model.CpmIndoorBanner;
import ru.yandex.direct.core.entity.banner.model.CpmOutdoorBanner;
import ru.yandex.direct.core.entity.banner.model.ImageBanner;
import ru.yandex.direct.core.entity.banner.model.MobileAppBanner;
import ru.yandex.direct.core.entity.banner.model.PerformanceBanner;
import ru.yandex.direct.core.entity.banner.model.TextBanner;
import ru.yandex.direct.core.entity.creative.model.CreativeBusinessType;
import ru.yandex.direct.core.entity.creative.model.CreativeType;
import ru.yandex.direct.core.entity.feed.model.BusinessType;

public class BannerWithCreativeConstants {
    /**
     * Соответствие между типом фида и тематиками смартовых креативов,
     * которые можно использовать для фида этого типа
     * (такая же таблица есть в бекенде старого конструктора смартов — AdDesigner'a)
     * Источник правды (продуктово) - Дима Уляшев
     */
    public static final Map<BusinessType, Set<CreativeBusinessType>> FEEDS_CREATIVES_COMPATIBILITY =
            Map.of(
                    BusinessType.RETAIL, Set.of(CreativeBusinessType.RETAIL, CreativeBusinessType.PHARM),
                    BusinessType.HOTELS, Set.of(CreativeBusinessType.HOTELS),
                    BusinessType.AUTO, Set.of(CreativeBusinessType.AUTO),
                    BusinessType.REALTY, Set.of(CreativeBusinessType.REALTY),
                    BusinessType.NEWS, Set.of(CreativeBusinessType.NEWS),
                    BusinessType.FLIGHTS, Set.of(CreativeBusinessType.FLIGHTS),
                    BusinessType.OTHER, Set.of(CreativeBusinessType.OTHER, CreativeBusinessType.PHARM)
            );

    public static final Map<Class<? extends Banner>, Set<CreativeType>> ALLOWED_CREATIVES_IN_BANNER_CLASS =
            ImmutableMap.<Class<? extends Banner>, Set<CreativeType>>builder()
                    .put(TextBanner.class, ImmutableSet.of(CreativeType.VIDEO_ADDITION_CREATIVE))
                    .put(CpcVideoBanner.class, ImmutableSet.of(CreativeType.CPC_VIDEO_CREATIVE))
                    .put(CpmBanner.class, ImmutableSet
                            .of(CreativeType.CPM_VIDEO_CREATIVE, CreativeType.HTML5_CREATIVE, CreativeType.CANVAS,
                                    CreativeType.CPM_OVERLAY, CreativeType.BANNERSTORAGE,
                                    CreativeType.CPM_AUDIO_CREATIVE))
                    .put(MobileAppBanner.class, ImmutableSet.of(CreativeType.VIDEO_ADDITION_CREATIVE))
                    //HTML5_CREATIVE доступен imageBanner-у только по фиче в
                    // BannerWithCreativeValidatorProvider.creativeValidator
                    .put(ImageBanner.class, ImmutableSet.of(CreativeType.CANVAS, CreativeType.HTML5_CREATIVE))
                    .put(CpmAudioBanner.class, ImmutableSet.of(CreativeType.CPM_AUDIO_CREATIVE,
                            CreativeType.BANNERSTORAGE))
                    .put(CpmGeoPinBanner.class, ImmutableSet.of(CreativeType.CANVAS))
                    .put(PerformanceBanner.class, ImmutableSet.of(CreativeType.PERFORMANCE))
                    .put(CpmOutdoorBanner.class, ImmutableSet.of(CreativeType.CPM_OUTDOOR_CREATIVE,
                            CreativeType.BANNERSTORAGE))
                    .put(CpmIndoorBanner.class, ImmutableSet.of(CreativeType.CPM_INDOOR_CREATIVE,
                            CreativeType.BANNERSTORAGE))
                    .build();

    private BannerWithCreativeConstants() {
    }
}
